#!/bin/sh

set -u

res=0
status_file_path="/usr/share/smw/tests/"
def_file_ext=".json"
status_file_ext=".txt"

if [ $# -lt 1 ]
then
  echo "This script needs at least one Test definition file"
  exit 1
fi

#
# Check if the ELE Daemon is present
# If not active, start it
#
if [ -e /etc/systemd/system/nvm_daemon.service ]; then
  res=$(systemctl is-active nvm_daemon)
  if [ "${res}" != "active" ]; then
    systemctl start nvm_daemon
    res=$(systemctl is-active nvm_daemon)
    if [ "${res}" != "active" ]; then
      echo "NVM Daemon start failure"
      systemctl -l status nvm_daemon
      exit 1
    fi
  fi
fi

final_status_file=
if [ $# -gt 1 ]; then
  final_status_file=$(basename "$1")
  final_status_file="${final_status_file%%.*}"
  final_status_file="${status_file_path}${final_status_file}${status_file_ext}"
  touch "${final_status_file}"
fi

for def in "$@"
do
  smwtest -d "${def}"
  res=$?

  if [ -n "${final_status_file}" ]; then
    status_file=$(basename "${def}" "${def_file_ext}")
    status_file="${status_file_path}${status_file}${status_file_ext}"
    cat "${status_file}" >> "${final_status_file}"
    rm "${status_file}"
  fi

  if [ "${res}" -gt 1 ]; then
    echo "${def} test failed (${res})"
    break
  fi

  shift
done

exit ${res}
